type
  IDaneOsobowe = interface
  ['{671FDA43-BD31-417C-9F9D-83BA5156D5AD}']
    function Imi: string;
    function Nazwisko: string;
  end;

// -----------------------------------------------------------------------------

type
  TOsoba = class(TInterfacedObject, IDaneOsobowe)
  protected
    function Imi: string;
    function Nazwisko: string;
  end;

function TOsoba.Imi: string;
begin
  // Informacje mona pozyskiwa z bazy danych lub inny sposb,
  // ale na potrzeby przykadu s one wpisane na stae
  Result := 'Adam';
end;

function TOsoba.Nazwisko: string;
begin
  // Informacje mona pozyskiwa z bazy danych lub inny sposb,
  // ale na potrzeby przykadu s one wpisane na stae
  Result := 'Wojciechowski';
end;

// -----------------------------------------------------------------------------

type
  IWiek = interface
    ['{3D7E1BBE-6273-47A9-9CB7-CB31FDF6AB69}']
    function OdczytajWiek: integer;
    procedure ZapiszWiek(Warto: integer);
    property Wiek: integer read OdczytajWiek write ZapiszWiek;
  end;

// -----------------------------------------------------------------------------

TKlasaWieku = class(TInterfacedObject, IWiek)
  private
    FWiek: integer;
    function OdczytajWiek: integer;
    procedure ZapiszWiek(Warto: integer);
  public
    property Wiek: integer read OdczytajWiek write ZapiszWiek;
end;

// -----------------------------------------------------------------------------

TWiekOsoby = class(TInterfacedObject, IDaneOsobowe, IWiek)
  private
    FWiek: integer;
    function OdczytajWiek: integer;
    procedure ZapiszWiek(Warto: integer);
  public
    function Imi: string;
    function Nazwisko: string;
  property Wiek: integer read OdczytajWiek write ZapiszWiek;
end;

// -----------------------------------------------------------------------------

IImiNazwisko = interface(IDaneOsobowe)
  ['{07E8CFE2-4C2B-41F4-8934-D9D3B5BE39BC}']
  function ImiNazwisko: string;
end;

// -----------------------------------------------------------------------------

procedure NieMylReferencjiDoInterfejswIDoObiektw;
var
  ReferencjaDoObiektu: TInterfacedObject;
  ReferencjaDoInterfejsu: IInterface;
begin
  ReferencjaDoObiektu := TInterfacedObject.Create();
  // Licznik RefCount ma warto 0
  ReferencjaDoInterfejsu := ReferencjaDoObiektu;
  // Licznik RefCount ma warto 1
  ReferencjaDoInterfejsu := nil;
  // W ten sposb licznik RefCount przyjmuje warto 0 i zwalniany jest obiekt,
  // ale ReferencjaDoObiektu ma wci nadan warto i moe by uyta
end;

// -----------------------------------------------------------------------------

var
  OkrelonaOsoba: IDaneOsobowe;

begin
  OkrelonaOsoba:= TOsoba.Create;
  WriteLn(OkrelonaOsoba.Imi, ' ', OkrelonaOsoba.Nazwisko, ' istnieje w bazie.');
end;

// -----------------------------------------------------------------------------

procedure Szyfrowanie(PoufneDane: TBufor; const TrzebaZaszyfrowa: Boolean);
var
  Szyfrator: ISzyfrator;
begin
  if TrzebaZaszyfrowa then
  begin
    Szyfrator := TSuperBezpieczneSzyfrowanie.Create;
  end else
  begin
   Szyfrator := TWszystkoJednoJakieSzyfrowanie.Create;
  end;
  Szyfrator.Szyfruj(PoufneDane);
end;
